/******************************************************************************
 CCompileTask.h

			Source File For CCompileTask Class
	

	Copyright (C) 1985-1992  New York University
	Copyright (C) 1994 George Washington University
	 
	This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
	system.  See the Ada/Ed README file for warranty (none) and distribution
	info and also the GNU General Public License for more details.


	by Manuel A. Perez

 ******************************************************************************/

#include <TBUtilities.h>
#include <Exceptions.h>

#include "CCompileTask.h"
#include "CAdaApp.h"
#include "CSourceDocument.h"
#include "ErrMessages.h"
#include "FileNames.h"
#include "AdaGlobals.h"


/****
 *	ICompileTask
 *
 ****/
void	CCompileTask::ICompileTask(CSourceDocument *doc, Str255 name)
{
	itsDoc = doc;
	listingCreated = false;
	IBkgndTask(name);
}

/****
 *	Dispose
 *
 ****/
void	CCompileTask::Dispose(void)
{
	itsDoc = NULL;
	inherited::Dispose();
}


/****
 *	GetSourceName()
 *
 ****/

void	CCompileTask:: GetSourceName(Str255 nameOnly)
{
	Str255 n;

	itsDoc->GetFileName(n);
	ParseFile(n, flName, nameOnly);
}

/****
 *	GetDocument()
 *
 ****/

CSourceDocument	*CCompileTask::GetDocument(void)
{
	return itsDoc;
}

/****
 *	CompilerError
 *
 *	adafront and adagen share the same CompilerError routine. If there
 *	are any errors in these two parts of the compiler, the .msg file must
 *	be read in and converted into a listing file.
 *
 ****/

void	CCompileTask::CompilerError(void)
{
	Str255 str;

	CreateListing();

	GetIndString(str, 20030, 1);	// Get String Compiling
	ParamText(str, NULL, NULL, NULL);
	gAdaApp->FinishedBkgnd(20021, true);
/**	NoteAlert(20021, NULL);	**/		// Failed

	itsDoc->OpenListing();
}


void	CCompileTask::CreateListing(void)
{
	if (!listingCreated) {
		Str255 nameOnly;
	
		// Create listing file
		GetSourceName(nameOnly);
		itsDoc->CreateListing(nameOnly);
	}
}
